/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.adapter.LeaderboardAdapter;
import com.ElyStudio.leGaou.databinding.FragmentLeaderboardBinding;
import com.ElyStudio.leGaou.models.GetLeaderboardData;
import com.ElyStudio.leGaou.models.Leaderboard;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.squareup.picasso.Picasso;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LeaderboardFragment
extends Fragment {
    FragmentLeaderboardBinding binding;
    Context contextFragment;
    BottomSheetDialog noInternetBottomSheet;
    BottomSheetDialog errorOccurredBottomSheet;
    public static final String TAG = "LEADERBOARD_SCREEN";

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = FragmentLeaderboardBinding.inflate(inflater, container, false);
        return this.binding.getRoot();
    }

    public void onStart() {
        super.onStart();
        this.getLeaderboardData();
    }

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.contextFragment = context;
    }

    public Context getContextNullSafety() {
        if (this.getContext() != null) {
            return this.getContext();
        }
        if (this.getActivity() != null) {
            return this.getActivity();
        }
        if (this.contextFragment != null) {
            return this.contextFragment;
        }
        if (this.getView() != null && this.getView().getContext() != null) {
            return this.getView().getContext();
        }
        if (this.requireContext() != null) {
            return this.requireContext();
        }
        if (this.requireActivity() != null) {
            return this.requireActivity();
        }
        if (this.requireView() != null && this.requireView().getContext() != null) {
            return this.requireView().getContext();
        }
        return null;
    }

    public FragmentActivity getActivityNullSafety() {
        if (this.getContextNullSafety() != null && this.getContextNullSafety() instanceof FragmentActivity) {
            return (FragmentActivity)this.getContextNullSafety();
        }
        return null;
    }

    private void getLeaderboardData() {
        if (CheckInternetConnection.isInternetConnected(this.getContextNullSafety())) {
            Call<GetLeaderboardData> getLeaderboardDataCall = ApiController.getInstance().getApi().getLeaderboardData();
            getLeaderboardDataCall.enqueue((Callback)new Callback<GetLeaderboardData>(){

                public void onResponse(Call<GetLeaderboardData> call, Response<GetLeaderboardData> response) {
                    if (((GetLeaderboardData)response.body()).getStatusCode() == 0) {
                        if (((GetLeaderboardData)response.body()).getTopRankers() != null) {
                            LeaderboardFragment.this.setTopRankData(((GetLeaderboardData)response.body()).getTopRankers());
                        }
                        if (((GetLeaderboardData)response.body()).getLeaderboardList() != null) {
                            LeaderboardFragment.this.setLeaderboardRecyclerview(((GetLeaderboardData)response.body()).getLeaderboardList());
                        }
                    }
                }

                public void onFailure(Call<GetLeaderboardData> call, Throwable t) {
                    Log.d((String)LeaderboardFragment.TAG, (String)("getLeaderboardDataCall Failure = " + t.getLocalizedMessage()));
                    LeaderboardFragment.this.showErrorOccurredBottomSheet();
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    private void setTopRankData(List<Leaderboard> topRankerList) {
        if (topRankerList.size() > 2) {
            Log.d((String)TAG, (String)("TOP RANK SIZE = " + topRankerList.size()));
            if (!topRankerList.get(0).getAvatar().trim().equals("")) {
                Picasso.get().load("https://gaou.biogenesis.fr/" + topRankerList.get(0).getAvatar()).into(this.binding.firstRankAvatar);
            }
            this.binding.firstRankName.setText((CharSequence)topRankerList.get(0).getName());
            this.binding.firstRankCoins.setText((CharSequence)String.valueOf(topRankerList.get(0).getCoins()));
            if (!topRankerList.get(1).getAvatar().trim().equals("")) {
                Picasso.get().load("https://gaou.biogenesis.fr/" + topRankerList.get(1).getAvatar()).into(this.binding.secondRankAvatar);
            }
            this.binding.secondRankCoins.setText((CharSequence)topRankerList.get(1).getName());
            this.binding.secondRankCoins.setText((CharSequence)String.valueOf(topRankerList.get(1).getCoins()));
            if (!topRankerList.get(2).getAvatar().trim().equals("")) {
                Picasso.get().load("https://gaou.biogenesis.fr/" + topRankerList.get(2).getAvatar()).into(this.binding.thirdRankAvatar);
            }
            this.binding.thirdRankName.setText((CharSequence)topRankerList.get(2).getName());
            this.binding.thirdRankCoins.setText((CharSequence)String.valueOf(topRankerList.get(2).getCoins()));
        } else {
            this.binding.crownIcon.setVisibility(8);
            this.binding.firstRankAvatarCard.setVisibility(8);
            this.binding.firstRankName.setVisibility(8);
            this.binding.firstRankCoins.setVisibility(8);
            this.binding.firstRankLayout.setVisibility(8);
            this.binding.secondRankAvatarCard.setVisibility(8);
            this.binding.secondRankName.setVisibility(8);
            this.binding.secondRankCoins.setVisibility(8);
            this.binding.secondRankLayout.setVisibility(8);
            this.binding.thirdRankAvatarCard.setVisibility(8);
            this.binding.thirdRankName.setVisibility(8);
            this.binding.thirdRankCoins.setVisibility(8);
            this.binding.thirdRankLayout.setVisibility(8);
        }
    }

    private void setLeaderboardRecyclerview(List<Leaderboard> leaderboardList) {
        LeaderboardAdapter adapter = new LeaderboardAdapter(leaderboardList);
        this.binding.leaderboardRecyclerview.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 1, false));
        this.binding.leaderboardRecyclerview.setAdapter((RecyclerView.Adapter)adapter);
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog(this.getContextNullSafety());
        final View view = LayoutInflater.from((Context)this.getContextNullSafety()).inflate(2131492934, (ViewGroup)((ConstraintLayout)this.getActivityNullSafety().findViewById(2131296534)), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected(LeaderboardFragment.this.getContextNullSafety())) {
                    LeaderboardFragment.this.getLeaderboardData();
                    LeaderboardFragment.this.noInternetBottomSheet.cancel();
                } else {
                    QuizzeSnackBar.showSnackBar(LeaderboardFragment.this.getContextNullSafety(), view, LeaderboardFragment.this.getActivityNullSafety().getResources().getString(2131886351), LeaderboardFragment.this.getActivityNullSafety().getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this.getContextNullSafety(), (int)2131165481));
        if (!this.getActivityNullSafety().isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog(this.getContextNullSafety());
        View view = LayoutInflater.from((Context)this.getContextNullSafety()).inflate(2131492934, (ViewGroup)this.getActivityNullSafety().findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this.getContextNullSafety(), (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LeaderboardFragment.this.startActivity(new Intent((Context)LeaderboardFragment.this.getActivityNullSafety(), SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LeaderboardFragment.this.errorOccurredBottomSheet.cancel();
                LeaderboardFragment.this.getLeaderboardData();
            }
        });
        if (!this.getActivityNullSafety().isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }
}

