/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.AllQuizActivity;
import com.ElyStudio.leGaou.activities.DailyQuizScreen;
import com.ElyStudio.leGaou.activities.InviteEarnScreen;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.adapter.CategoryAdapter;
import com.ElyStudio.leGaou.adapter.QuizAdapter;
import com.ElyStudio.leGaou.databinding.FragmentHomeBinding;
import com.ElyStudio.leGaou.models.ApiResponse;
import com.ElyStudio.leGaou.models.Category;
import com.ElyStudio.leGaou.models.DailyQuizData;
import com.ElyStudio.leGaou.models.HomeScreenData;
import com.ElyStudio.leGaou.models.Quiz;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.GridViewSpacing;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.firebase.auth.FirebaseAuth;
import com.squareup.picasso.Picasso;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class HomeFragment
extends Fragment {
    FragmentHomeBinding binding;
    public static final String TAG = "HOME_FRAGMENT";
    RecyclerView quizRecyclerView;
    BottomSheetDialog congratsBottomSheet;
    Context contextFragment;
    int coins;
    int watchEarnReward;
    String nativeAdId;
    String interstitialAdId;
    String rewardedAdId;
    int adEnabled;
    Calendar calendar;
    String day;
    String month;
    String year;
    String currentDate;
    String backendDate;
    int checkInReward;
    RewardedAd mRewardedAd;
    String userInviteCode;
    String invitedBy;
    BottomSheetDialog errorOccurredBottomSheet;
    BottomSheetDialog noInternetBottomSheet;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = FragmentHomeBinding.inflate(inflater, container, false);
        MobileAds.initialize((Context)this.getContextNullSafety(), (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

            public void onInitializationComplete(InitializationStatus initializationStatus) {
            }
        });
        this.getHomeScreenData();
        this.binding.moreQuizButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)HomeFragment.this.getActivityNullSafety(), AllQuizActivity.class);
                intent.putExtra("categoryId", 0);
                intent.putExtra("userCoins", HomeFragment.this.coins);
                intent.putExtra("watchEarnReward", HomeFragment.this.watchEarnReward);
                intent.putExtra("adEnabled", HomeFragment.this.adEnabled);
                intent.putExtra("nativeAdId", HomeFragment.this.nativeAdId);
                intent.putExtra("interstitialAdId", HomeFragment.this.interstitialAdId);
                intent.putExtra("rewardedAdId", HomeFragment.this.rewardedAdId);
                HomeFragment.this.startActivity(intent);
            }
        });
        this.binding.dailyCheckInBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HomeFragment.this.dailyCheckIn();
            }
        });
        this.binding.inviteEarnCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)HomeFragment.this.getActivityNullSafety(), InviteEarnScreen.class);
                intent.putExtra("userInviteCode", HomeFragment.this.userInviteCode);
                intent.putExtra("invitedBy", HomeFragment.this.invitedBy);
                intent.putExtra("adEnabled", HomeFragment.this.adEnabled);
                intent.putExtra("rewardedAdId", HomeFragment.this.rewardedAdId);
                HomeFragment.this.startActivity(intent);
            }
        });
        this.binding.inviteBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)HomeFragment.this.getActivityNullSafety(), InviteEarnScreen.class);
                intent.putExtra("userInviteCode", HomeFragment.this.userInviteCode);
                intent.putExtra("invitedBy", HomeFragment.this.invitedBy);
                intent.putExtra("adEnabled", HomeFragment.this.adEnabled);
                intent.putExtra("rewardedAdId", HomeFragment.this.rewardedAdId);
                HomeFragment.this.startActivity(intent);
            }
        });
        return this.binding.getRoot();
    }

    void getHomeScreenData() {
        this.binding.loader.setVisibility(0);
        this.binding.homeQuizLayout.setVisibility(8);
        Call<HomeScreenData> getHomeScreenDataCall = ApiController.getInstance().getApi().getHomeScreenData(FirebaseAuth.getInstance().getUid());
        if (CheckInternetConnection.isInternetConnected(this.getContextNullSafety())) {
            getHomeScreenDataCall.enqueue((Callback)new Callback<HomeScreenData>(){

                public void onResponse(Call<HomeScreenData> call, Response<HomeScreenData> response) {
                    HomeFragment.this.binding.loader.setVisibility(8);
                    HomeFragment.this.binding.homeQuizLayout.setVisibility(0);
                    assert (response.body() != null);
                    int statusCode = ((HomeScreenData)response.body()).getStatusCode();
                    if (statusCode == 0) {
                        long timeInMillis = (long)((HomeScreenData)response.body()).getTime() * 1000L;
                        Calendar cd = Calendar.getInstance();
                        cd.setTimeInMillis(timeInMillis);
                        String day = String.valueOf(cd.get(5));
                        String month = String.valueOf(cd.get(2) + 1);
                        String year = String.valueOf(cd.get(1));
                        HomeFragment.this.userInviteCode = ((HomeScreenData)response.body()).getInviteCode();
                        HomeFragment.this.invitedBy = ((HomeScreenData)response.body()).getInvitedBy();
                        HomeFragment.this.backendDate = day + '/' + month + '/' + year;
                        HomeFragment.this.coins = ((HomeScreenData)response.body()).getCoins();
                        HomeFragment.this.checkInReward = ((HomeScreenData)response.body()).getCheckInReward();
                        HomeFragment.this.watchEarnReward = ((HomeScreenData)response.body()).getWatchEarnReward();
                        HomeFragment.this.nativeAdId = ((HomeScreenData)response.body()).getNativeAdId();
                        HomeFragment.this.interstitialAdId = ((HomeScreenData)response.body()).getInterstitialAdId();
                        HomeFragment.this.rewardedAdId = ((HomeScreenData)response.body()).getRewardedAdId();
                        HomeFragment.this.adEnabled = ((HomeScreenData)response.body()).getAdEnabled();
                        if (((HomeScreenData)response.body()).getQuizList() != null) {
                            HomeFragment.this.setQuizRecyclerView(((HomeScreenData)response.body()).getQuizList());
                        }
                        if (((HomeScreenData)response.body()).getCategoryList() != null) {
                            HomeFragment.this.setCategoryRecyclerView(((HomeScreenData)response.body()).getCategoryList());
                        }
                        Picasso.get().load("https://gaou.biogenesis.fr/" + ((HomeScreenData)response.body()).getAvatar()).into(HomeFragment.this.binding.userAvatar);
                        HomeFragment.this.binding.userName.setText((CharSequence)((HomeScreenData)response.body()).getName());
                        HomeFragment.this.binding.userCoins.setText((CharSequence)String.valueOf(((HomeScreenData)response.body()).getCoins()));
                        HomeFragment.this.binding.userLevelName.setText((CharSequence)((HomeScreenData)response.body()).getLevelName());
                        Picasso.get().load("https://gaou.biogenesis.fr/" + ((HomeScreenData)response.body()).getLevelIcon()).into(HomeFragment.this.binding.userLevelIcon);
                        if (HomeFragment.this.adEnabled == 1) {
                            HomeFragment.this.loadNativeAd(((HomeScreenData)response.body()).getNativeAdId(), HomeFragment.this.binding.adOnePlaceholder);
                            HomeFragment.this.loadNativeAd(((HomeScreenData)response.body()).getNativeAdId(), HomeFragment.this.binding.adPlaceHolderTwo);
                        }
                        HomeFragment.this.getDailyQuizData();
                        HomeFragment.this.loadRewardedAd(HomeFragment.this.rewardedAdId);
                        SharedPreferences sp = HomeFragment.this.getActivityNullSafety().getSharedPreferences("APP_PREFERENCES", 0);
                        String lastCheckInDate = sp.getString("lastCheckIn", "");
                        if (lastCheckInDate.equals(HomeFragment.this.backendDate)) {
                            HomeFragment.this.binding.dailyCheckInBtn.setEnabled(false);
                            HomeFragment.this.binding.dailyCheckInBtn.setText((CharSequence)HomeFragment.this.getContextNullSafety().getResources().getString(2131886133));
                        }
                        if (((HomeScreenData)response.body()).getIsLevelChanged() == 1) {
                            HomeFragment.this.showLevelCongratsBottomSheet(((HomeScreenData)response.body()).getLevelName(), ((HomeScreenData)response.body()).getLevelGreetings(), ((HomeScreenData)response.body()).getLevelIcon());
                        }
                    } else {
                        QuizzeSnackBar.showSnackBar(HomeFragment.this.getContextNullSafety(), (View)HomeFragment.this.binding.getRoot(), HomeFragment.this.getResources().getString(2131886415), HomeFragment.this.getResources().getColor(2131034225));
                        HomeFragment.this.showErrorOccurredBottomSheet();
                    }
                }

                public void onFailure(Call<HomeScreenData> call, Throwable t) {
                    Log.d((String)HomeFragment.TAG, (String)("getHomeScreenDataCall failure = " + t.getLocalizedMessage()));
                    HomeFragment.this.binding.loader.setVisibility(8);
                    HomeFragment.this.showErrorOccurredBottomSheet();
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    void setQuizRecyclerView(List<Quiz> quizList) {
        if (quizList.size() == 0) {
            this.binding.quizzeTag.setVisibility(8);
            this.binding.moreQuizButton.setVisibility(8);
        }
        this.quizRecyclerView = this.binding.quizRecyclerview;
        GridLayoutManager layoutManager = new GridLayoutManager(this.getContext(), 2, 1, false);
        QuizAdapter adapter = new QuizAdapter(this.getContextNullSafety(), quizList, (Activity)this.getActivityNullSafety(), (View)this.binding.getRoot(), this.coins, this.watchEarnReward, this.adEnabled, this.nativeAdId, this.interstitialAdId, this.rewardedAdId);
        this.quizRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new GridViewSpacing(2, 40, false));
        this.quizRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.quizRecyclerView.setAdapter((RecyclerView.Adapter)adapter);
    }

    void setCategoryRecyclerView(List<Category> categoryList) {
        if (categoryList.size() == 0) {
            this.binding.categoriesTag.setVisibility(8);
        }
        RecyclerView categoryRecyclerView = this.binding.categoriesRecyclerview;
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext(), 0, false);
        CategoryAdapter adapter = new CategoryAdapter(this.getContext(), categoryList, this.adEnabled, this.coins, this.watchEarnReward, this.nativeAdId, this.interstitialAdId, this.rewardedAdId);
        categoryRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        categoryRecyclerView.setAdapter((RecyclerView.Adapter)adapter);
    }

    void showLevelCongratsBottomSheet(String name, String greetings, String icon) {
        Random random = new Random();
        int randomColor = random.nextInt(9);
        int color2 = randomColor == 1 ? this.getContextNullSafety().getResources().getColor(2131034759) : (randomColor == 2 ? this.getContextNullSafety().getResources().getColor(2131034760) : (randomColor == 3 ? this.getContextNullSafety().getResources().getColor(2131034761) : (randomColor == 4 ? this.getContextNullSafety().getResources().getColor(2131034762) : (randomColor == 5 ? this.getContextNullSafety().getResources().getColor(2131034763) : (randomColor == 6 ? this.getContextNullSafety().getResources().getColor(2131034764) : (randomColor == 7 ? this.getContextNullSafety().getResources().getColor(2131034765) : (randomColor == 8 ? this.getContextNullSafety().getResources().getColor(2131034766) : this.getContextNullSafety().getResources().getColor(2131034732))))))));
        this.congratsBottomSheet = new BottomSheetDialog(this.getContextNullSafety());
        View view = LayoutInflater.from((Context)this.getContext()).inflate(2131492943, (ViewGroup)((ConstraintLayout)this.getActivityNullSafety().findViewById(2131296464)));
        this.congratsBottomSheet.setContentView(view);
        TextView congratsTitle = (TextView)this.congratsBottomSheet.findViewById(2131296672);
        TextView congratsGreetings = (TextView)this.congratsBottomSheet.findViewById(2131296673);
        ImageView levelIcon = (ImageView)this.congratsBottomSheet.findViewById(2131296465);
        Button thanksButton = (Button)this.congratsBottomSheet.findViewById(2131297062);
        String title = this.getContextNullSafety().getResources().getString(2131886160) + ' ' + name;
        congratsTitle.setTextColor(color2);
        congratsTitle.setText((CharSequence)title);
        Picasso.get().load("https://gaou.biogenesis.fr/" + icon).into(levelIcon);
        congratsGreetings.setText((CharSequence)greetings);
        thanksButton.setBackgroundColor(color2);
        thanksButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HomeFragment.this.congratsBottomSheet.cancel();
            }
        });
        if (!this.getActivityNullSafety().isFinishing()) {
            this.congratsBottomSheet.show();
        }
    }

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.contextFragment = context;
    }

    public Context getContextNullSafety() {
        if (this.getContext() != null) {
            return this.getContext();
        }
        if (this.getActivity() != null) {
            return this.getActivity();
        }
        if (this.contextFragment != null) {
            return this.contextFragment;
        }
        if (this.getView() != null && this.getView().getContext() != null) {
            return this.getView().getContext();
        }
        if (this.requireContext() != null) {
            return this.requireContext();
        }
        if (this.requireActivity() != null) {
            return this.requireActivity();
        }
        if (this.requireView() != null && this.requireView().getContext() != null) {
            return this.requireView().getContext();
        }
        return null;
    }

    public FragmentActivity getActivityNullSafety() {
        if (this.getContextNullSafety() != null && this.getContextNullSafety() instanceof FragmentActivity) {
            return (FragmentActivity)this.getContextNullSafety();
        }
        return null;
    }

    public void populateNativeAdView(NativeAd nativeAd, NativeAdView nativeAdView) {
        nativeAdView.setMediaView((MediaView)nativeAdView.findViewById(2131296350));
        nativeAdView.setIconView(nativeAdView.findViewById(2131296345));
        nativeAdView.setHeadlineView(nativeAdView.findViewById(2131296342));
        nativeAdView.setAdvertiserView(nativeAdView.findViewById(2131296366));
        nativeAdView.setStarRatingView(nativeAdView.findViewById(2131296360));
        nativeAdView.setBodyView(nativeAdView.findViewById(2131296335));
        nativeAdView.setPriceView(nativeAdView.findViewById(2131296357));
        nativeAdView.setStoreView(nativeAdView.findViewById(2131296361));
        nativeAdView.setCallToActionView(nativeAdView.findViewById(2131296425));
        if (nativeAd != null) {
            ((TextView)nativeAdView.getHeadlineView()).setText((CharSequence)nativeAd.getHeadline());
            nativeAdView.getMediaView().setMediaContent(nativeAd.getMediaContent());
            if (nativeAd.getBody() == null) {
                nativeAdView.getBodyView().setVisibility(4);
            } else {
                nativeAdView.getBodyView().setVisibility(0);
                ((TextView)nativeAdView.getBodyView()).setText((CharSequence)nativeAd.getBody());
            }
            if (nativeAd.getAdvertiser() == null) {
                nativeAdView.getAdvertiserView().setVisibility(4);
            } else {
                nativeAdView.getAdvertiserView().setVisibility(0);
                ((TextView)nativeAdView.getAdvertiserView()).setText((CharSequence)nativeAd.getAdvertiser());
            }
            if (nativeAd.getStarRating() == null) {
                nativeAdView.getStarRatingView().setVisibility(4);
            } else {
                nativeAdView.getStarRatingView().setVisibility(0);
                ((RatingBar)nativeAdView.getStarRatingView()).setRating(nativeAd.getStarRating().floatValue());
            }
            if (nativeAd.getIcon() == null) {
                nativeAdView.getIconView().setVisibility(4);
            } else {
                nativeAdView.getIconView().setVisibility(0);
                ((ImageView)nativeAdView.getIconView()).setImageDrawable(nativeAd.getIcon().getDrawable());
            }
            if (nativeAd.getPrice() == null) {
                nativeAdView.getPriceView().setVisibility(4);
            } else {
                nativeAdView.getPriceView().setVisibility(0);
                ((TextView)nativeAdView.getPriceView()).setText((CharSequence)nativeAd.getPrice());
            }
            if (nativeAd.getStore() == null) {
                nativeAdView.getStoreView().setVisibility(4);
            } else {
                nativeAdView.getStoreView().setVisibility(0);
                ((TextView)nativeAdView.getStoreView()).setText((CharSequence)nativeAd.getStore());
            }
            if (nativeAd.getCallToAction() == null) {
                nativeAdView.getCallToActionView().setVisibility(4);
            } else {
                nativeAdView.getCallToActionView().setVisibility(0);
                ((Button)nativeAdView.getCallToActionView()).setText((CharSequence)nativeAd.getCallToAction());
            }
            nativeAdView.setNativeAd(nativeAd);
        }
    }

    public void loadNativeAd(String adId, final FrameLayout frameLayout) {
        AdLoader.Builder builder = new AdLoader.Builder(this.getContextNullSafety(), adId);
        builder.forNativeAd(new NativeAd.OnNativeAdLoadedListener(){

            public void onNativeAdLoaded(@NonNull NativeAd nativeAd) {
                NativeAdView nativeAdView = (NativeAdView)HomeFragment.this.getActivityNullSafety().getLayoutInflater().inflate(2131492913, null);
                HomeFragment.this.populateNativeAdView(nativeAd, nativeAdView);
                frameLayout.removeAllViews();
                frameLayout.addView((View)nativeAdView);
            }
        });
        VideoOptions videoOptions = new VideoOptions.Builder().setStartMuted(true).build();
        NativeAdOptions adOptions = new NativeAdOptions.Builder().setVideoOptions(videoOptions).build();
        builder.withNativeAdOptions(adOptions);
        AdLoader adLoader = builder.withAdListener(new AdListener(){

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                super.onAdFailedToLoad(loadAdError);
                Log.d((String)HomeFragment.TAG, (String)("Failed to native ad = " + loadAdError.getMessage()));
            }
        }).build();
        adLoader.loadAd(new AdRequest.Builder().build());
    }

    private void getDailyQuizData() {
        this.calendar = Calendar.getInstance();
        this.day = String.valueOf(this.calendar.get(5));
        this.month = String.valueOf(this.calendar.get(2) + 1);
        this.year = String.valueOf(this.calendar.get(1));
        this.currentDate = this.day + '/' + this.month + '/' + this.year;
        SharedPreferences sharedPreferences = this.getActivityNullSafety().getSharedPreferences("APP_PREFERENCES", 0);
        String lastPlayedDate = sharedPreferences.getString("isDailyQuizPlayed", "");
        final SharedPreferences.Editor editor = sharedPreferences.edit();
        if (lastPlayedDate.equals(this.backendDate)) {
            this.binding.playDailyQuizBtn.setText((CharSequence)this.getContextNullSafety().getResources().getString(2131886380));
            this.binding.playDailyQuizBtn.setEnabled(false);
        } else {
            Call<DailyQuizData> getDailyQuizData = ApiController.getInstance().getApi().getDailyQuizData();
            getDailyQuizData.enqueue((Callback)new Callback<DailyQuizData>(){

                public void onResponse(Call<DailyQuizData> call, final Response<DailyQuizData> response) {
                    if (((DailyQuizData)response.body()).getStatusCode() == 0) {
                        if (((DailyQuizData)response.body()).getDailyQuizQuestions() == null || ((DailyQuizData)response.body()).getDailyQuizQuestions().size() == 0) {
                            HomeFragment.this.binding.dailyQuizCard.setVisibility(4);
                        } else {
                            HomeFragment.this.binding.playDailyQuizBtn.setOnClickListener(new View.OnClickListener(){

                                public void onClick(View v) {
                                    editor.putString("isDailyQuizPlayed", HomeFragment.this.currentDate);
                                    editor.apply();
                                    HomeFragment.this.startDailyQuiz(HomeFragment.this.getContextNullSafety().getResources().getString(2131886169), ((DailyQuizData)response.body()).getEntryFee(), ((DailyQuizData)response.body()).getLivesAvailable(), ((DailyQuizData)response.body()).getQuestionLimit(), ((DailyQuizData)response.body()).getPrize(), ((DailyQuizData)response.body()).getTime());
                                }
                            });
                        }
                    }
                }

                public void onFailure(Call<DailyQuizData> call, Throwable t) {
                    Log.d((String)HomeFragment.TAG, (String)("getDailyQuizDataCallFailure = " + t.getLocalizedMessage()));
                }
            });
        }
    }

    public void startDailyQuiz(String quizName, int quizEntryFee, int livesAvailable, int questionLimit, float prizePerQuestion, int time) {
        Intent intent = new Intent(this.getContextNullSafety(), DailyQuizScreen.class);
        intent.putExtra("quizName", quizName);
        intent.putExtra("quizEntryFee", quizEntryFee);
        intent.putExtra("quizQuestionLimit", questionLimit);
        intent.putExtra("quizLivesAvailable", livesAvailable);
        intent.putExtra("quizTimeAvailable", time);
        intent.putExtra("quizPrizePerQuestion", prizePerQuestion);
        intent.putExtra("adEnabled", this.adEnabled);
        intent.putExtra("nativeAdId", this.nativeAdId);
        intent.putExtra("interstitialAdId", this.interstitialAdId);
        intent.putExtra("rewardedAdId", this.rewardedAdId);
        this.getContextNullSafety().startActivity(intent);
    }

    public void dailyCheckIn() {
        SharedPreferences preferences = this.getActivityNullSafety().getSharedPreferences("APP_PREFERENCES", 0);
        String lastCheckIn = preferences.getString("lastCheckIn", "");
        SharedPreferences.Editor editor = preferences.edit();
        if (lastCheckIn.equals(this.backendDate)) {
            this.binding.dailyCheckInBtn.setEnabled(false);
            this.binding.dailyCheckInBtn.setText((CharSequence)this.getResources().getString(2131886133));
        } else {
            editor.putString("lastCheckIn", this.backendDate).apply();
            Call<ApiResponse> addCheckInCoinsCall = ApiController.getInstance().getApi().addCoins(FirebaseAuth.getInstance().getUid(), this.checkInReward, "DAIlY CHECK IN", this.getActivityNullSafety().getResources().getString(2131886168));
            addCheckInCoinsCall.enqueue((Callback)new Callback<ApiResponse>(){

                public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                    if (((ApiResponse)response.body()).getStatusCode() == 0) {
                        if (HomeFragment.this.mRewardedAd != null) {
                            HomeFragment.this.mRewardedAd.show((Activity)HomeFragment.this.getActivityNullSafety(), new OnUserEarnedRewardListener(){

                                public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                                    QuizzeSnackBar.showSnackBar(HomeFragment.this.getContextNullSafety(), (View)HomeFragment.this.binding.getRoot(), HomeFragment.this.getResources().getString(2131886132), HomeFragment.this.getContextNullSafety().getResources().getColor(2131034780));
                                    HomeFragment.this.binding.dailyCheckInBtn.setEnabled(false);
                                    HomeFragment.this.binding.dailyCheckInBtn.setText((CharSequence)HomeFragment.this.getResources().getString(2131886133));
                                }
                            });
                        } else {
                            QuizzeSnackBar.showSnackBar(HomeFragment.this.getContextNullSafety(), (View)HomeFragment.this.binding.getRoot(), HomeFragment.this.getResources().getString(2131886132), HomeFragment.this.getContextNullSafety().getResources().getColor(2131034780));
                            HomeFragment.this.binding.dailyCheckInBtn.setEnabled(false);
                            HomeFragment.this.binding.dailyCheckInBtn.setText((CharSequence)HomeFragment.this.getResources().getString(2131886133));
                        }
                    } else {
                        QuizzeSnackBar.showSnackBar(HomeFragment.this.getContextNullSafety(), (View)HomeFragment.this.binding.getRoot(), HomeFragment.this.getContextNullSafety().getResources().getString(2131886224), HomeFragment.this.getContextNullSafety().getResources().getColor(2131034225));
                    }
                }

                public void onFailure(Call<ApiResponse> call, Throwable t) {
                    Log.d((String)HomeFragment.TAG, (String)("addCheckInCoinsCall Failure = " + t.getLocalizedMessage()));
                    QuizzeSnackBar.showSnackBar(HomeFragment.this.getContextNullSafety(), (View)HomeFragment.this.binding.getRoot(), HomeFragment.this.getContextNullSafety().getResources().getString(2131886416), HomeFragment.this.getContextNullSafety().getResources().getColor(2131034225));
                }
            });
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog(this.getContextNullSafety());
        View view = LayoutInflater.from((Context)this.getContextNullSafety()).inflate(2131492934, (ViewGroup)this.getActivityNullSafety().findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this.getContextNullSafety(), (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HomeFragment.this.startActivity(new Intent((Context)HomeFragment.this.getActivityNullSafety(), SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HomeFragment.this.errorOccurredBottomSheet.cancel();
                HomeFragment.this.getHomeScreenData();
            }
        });
        if (!this.getActivityNullSafety().isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog(this.getContextNullSafety());
        final View view = LayoutInflater.from((Context)this.getContextNullSafety()).inflate(2131492934, (ViewGroup)this.getActivityNullSafety().findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getContextNullSafety().getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected(HomeFragment.this.getContextNullSafety())) {
                    HomeFragment.this.getHomeScreenData();
                    HomeFragment.this.noInternetBottomSheet.cancel();
                } else {
                    QuizzeSnackBar.showSnackBar(HomeFragment.this.getContextNullSafety(), view, HomeFragment.this.getResources().getString(2131886351), HomeFragment.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getContextNullSafety().getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getContextNullSafety().getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this.getContextNullSafety(), (int)2131165481));
        if (!this.getActivityNullSafety().isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    private void loadRewardedAd(String adId) {
        if (this.adEnabled == 1) {
            AdRequest adRequest = new AdRequest.Builder().build();
            RewardedAd.load((Context)this.getContextNullSafety(), (String)adId, (AdRequest)adRequest, (RewardedAdLoadCallback)new RewardedAdLoadCallback(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d((String)HomeFragment.TAG, (String)("Failed to load rewarded ad = " + loadAdError));
                    HomeFragment.this.mRewardedAd = null;
                }

                public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
                    super.onAdLoaded((Object)rewardedAd);
                    HomeFragment.this.mRewardedAd = rewardedAd;
                }
            });
        }
    }
}

