/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.models.WithdrawMethods;
import com.ElyStudio.leGaou.utilities.OnWithdrawMethodSelect;
import com.google.android.material.card.MaterialCardView;
import com.squareup.picasso.Picasso;
import java.util.List;

public class WithdrawMethodAdapter
extends RecyclerView.Adapter<WithdrawMethodViewHolder> {
    private List<WithdrawMethods> withdrawMethodsList;
    private Context context;
    private OnWithdrawMethodSelect mCallback;
    int selectedIndex = 0;

    public WithdrawMethodAdapter(List<WithdrawMethods> withdrawMethodsList, Context context, OnWithdrawMethodSelect mCallback) {
        this.withdrawMethodsList = withdrawMethodsList;
        this.context = context;
        this.mCallback = mCallback;
    }

    @NonNull
    public WithdrawMethodViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new WithdrawMethodViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(2131493021, parent, false));
    }

    public void onBindViewHolder(final @NonNull WithdrawMethodViewHolder holder, int position) {
        final WithdrawMethods withdrawMethods = this.withdrawMethodsList.get(position);
        if (!this.withdrawMethodsList.get(position).getIcon().trim().equals("")) {
            Picasso.get().load("https://gaou.biogenesis.fr/" + this.withdrawMethodsList.get(position).getIcon()).into(holder.withdrawMethodIcon);
        }
        if (this.selectedIndex == position) {
            holder.withdrawMethodCard.setStrokeColor(this.context.getResources().getColor(2131034732));
        } else {
            holder.withdrawMethodCard.setStrokeColor(this.context.getResources().getColor(2131034798));
        }
        holder.withdrawMethodCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WithdrawMethodAdapter.this.selectedIndex = holder.getAdapterPosition();
                WithdrawMethodAdapter.this.mCallback.onMethodSelected(withdrawMethods.getName(), withdrawMethods.getIdName(), withdrawMethods.getIcon());
                WithdrawMethodAdapter.this.notifyDataSetChanged();
            }
        });
    }

    public int getItemCount() {
        return this.withdrawMethodsList.size();
    }

    public static class WithdrawMethodViewHolder
    extends RecyclerView.ViewHolder {
        ImageView withdrawMethodIcon;
        MaterialCardView withdrawMethodCard;

        public WithdrawMethodViewHolder(@NonNull View itemView) {
            super(itemView);
            this.withdrawMethodIcon = (ImageView)itemView.findViewById(2131297145);
            this.withdrawMethodCard = (MaterialCardView)itemView.findViewById(2131297143);
        }
    }
}

