/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.models.QuizHistory;
import com.squareup.picasso.Picasso;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class QuizHistoryAdapter
extends RecyclerView.Adapter<QuizHistoryViewHolder> {
    private final List<QuizHistory> quizHistoryList;
    private final Context context;

    public QuizHistoryAdapter(List<QuizHistory> quizHistoryList, Context context) {
        this.quizHistoryList = quizHistoryList;
        this.context = context;
    }

    @NonNull
    public QuizHistoryViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new QuizHistoryViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(2131493008, parent, false));
    }

    public void onBindViewHolder(@NonNull QuizHistoryViewHolder holder, int position) {
        int textColor;
        int bgColor;
        QuizHistory quizHistory = this.quizHistoryList.get(position);
        if (quizHistory.getColor() == 1) {
            bgColor = this.context.getResources().getColor(2131034750);
            textColor = this.context.getResources().getColor(2131034759);
        } else if (quizHistory.getColor() == 2) {
            bgColor = this.context.getResources().getColor(2131034751);
            textColor = this.context.getResources().getColor(2131034760);
        } else if (quizHistory.getColor() == 3) {
            bgColor = this.context.getResources().getColor(2131034752);
            textColor = this.context.getResources().getColor(2131034761);
        } else if (quizHistory.getColor() == 4) {
            bgColor = this.context.getResources().getColor(2131034753);
            textColor = this.context.getResources().getColor(2131034762);
        } else if (quizHistory.getColor() == 5) {
            bgColor = this.context.getResources().getColor(2131034754);
            textColor = this.context.getResources().getColor(2131034763);
        } else if (quizHistory.getColor() == 6) {
            bgColor = this.context.getResources().getColor(2131034755);
            textColor = this.context.getResources().getColor(2131034764);
        } else if (quizHistory.getColor() == 7) {
            bgColor = this.context.getResources().getColor(2131034756);
            textColor = this.context.getResources().getColor(2131034765);
        } else if (quizHistory.getColor() == 8) {
            bgColor = this.context.getResources().getColor(2131034757);
            textColor = this.context.getResources().getColor(2131034766);
        } else {
            bgColor = this.context.getResources().getColor(2131034758);
            textColor = this.context.getResources().getColor(2131034742);
        }
        holder.quizName.setText((CharSequence)quizHistory.getQuizName());
        holder.quizIconBg.setBackgroundColor(bgColor);
        if (quizHistory.getEntryFee() == 0) {
            holder.quizEntryFee.setText((CharSequence)this.context.getResources().getString(2131886202));
        } else {
            holder.quizEntryFee.setText((CharSequence)String.valueOf(quizHistory.getEntryFee()));
        }
        holder.quizPrize.setText((CharSequence)String.valueOf(quizHistory.getPrize()));
        holder.questionAttempted.setText((CharSequence)String.valueOf(quizHistory.getQuestionAttempted()));
        holder.correctAnswers.setText((CharSequence)String.valueOf(quizHistory.getCorrectAnswers()));
        holder.wrongAnswers.setText((CharSequence)String.valueOf(quizHistory.getWrongAnswers()));
        holder.quizName.setTextColor(textColor);
        if (quizHistory.getIcon().trim().isEmpty()) {
            holder.quizIcon.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)2131165413));
        } else {
            Picasso.get().load("https://gaou.biogenesis.fr/" + quizHistory.getIcon()).into(holder.quizIcon);
        }
        Date date = new Date(Long.parseLong(quizHistory.getDate()) * 1000L);
        String playingTime = new SimpleDateFormat("d MMM yyyy, hh:mm aaa", Locale.getDefault()).format(date);
        holder.playingDate.setText((CharSequence)playingTime);
    }

    public int getItemCount() {
        return this.quizHistoryList.size();
    }

    public static class QuizHistoryViewHolder
    extends RecyclerView.ViewHolder {
        ImageView quizIcon;
        FrameLayout quizIconBg;
        TextView quizName;
        TextView quizEntryFee;
        TextView quizPrize;
        TextView questionAttempted;
        TextView correctAnswers;
        TextView wrongAnswers;
        TextView playingDate;

        public QuizHistoryViewHolder(@NonNull View itemView) {
            super(itemView);
            this.quizIcon = (ImageView)itemView.findViewById(2131296869);
            this.quizName = (TextView)itemView.findViewById(2131296870);
            this.quizIconBg = (FrameLayout)itemView.findViewById(2131296876);
            this.quizEntryFee = (TextView)itemView.findViewById(2131296868);
            this.quizPrize = (TextView)itemView.findViewById(2131296871);
            this.questionAttempted = (TextView)itemView.findViewById(2131296872);
            this.correctAnswers = (TextView)itemView.findViewById(2131296866);
            this.wrongAnswers = (TextView)itemView.findViewById(2131296874);
            this.playingDate = (TextView)itemView.findViewById(2131296867);
        }
    }
}

