/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.GameWebViewScreen;
import com.ElyStudio.leGaou.models.Games;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.material.card.MaterialCardView;
import com.squareup.picasso.Picasso;
import java.util.List;

public class GamesAdapter
extends RecyclerView.Adapter<GamesViewHolder> {
    private final Context context;
    private final Activity activity;
    private final List<Games> gamesList;
    private final int adEnabled;
    private final String interstitialAdId;
    private InterstitialAd mInterstitialAd;
    public static final String TAG = "GAMES_ADAPTER";

    public GamesAdapter(Context context, Activity activity, List<Games> gamesList, int adEnabled, String interstitialAdId) {
        this.context = context;
        this.activity = activity;
        this.gamesList = gamesList;
        this.adEnabled = adEnabled;
        this.interstitialAdId = interstitialAdId;
    }

    @NonNull
    public GamesViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new GamesViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(2131492940, parent, false));
    }

    public void onBindViewHolder(@NonNull GamesViewHolder holder, int position) {
        int cardBgColor;
        int textColor;
        final Games games = this.gamesList.get(position);
        this.loadInterstitialAd();
        if (games.getColorCode() == 1) {
            textColor = this.context.getResources().getColor(2131034759);
            cardBgColor = this.context.getResources().getColor(2131034750);
        } else if (games.getColorCode() == 2) {
            textColor = this.context.getResources().getColor(2131034760);
            cardBgColor = this.context.getResources().getColor(2131034751);
        } else if (games.getColorCode() == 3) {
            textColor = this.context.getResources().getColor(2131034761);
            cardBgColor = this.context.getResources().getColor(2131034752);
        } else if (games.getColorCode() == 4) {
            textColor = this.context.getResources().getColor(2131034762);
            cardBgColor = this.context.getResources().getColor(2131034753);
        } else if (games.getColorCode() == 5) {
            textColor = this.context.getResources().getColor(2131034763);
            cardBgColor = this.context.getResources().getColor(2131034754);
        } else if (games.getColorCode() == 6) {
            textColor = this.context.getResources().getColor(2131034764);
            cardBgColor = this.context.getResources().getColor(2131034755);
        } else if (games.getColorCode() == 7) {
            textColor = this.context.getResources().getColor(2131034765);
            cardBgColor = this.context.getResources().getColor(2131034756);
        } else if (games.getColorCode() == 8) {
            textColor = this.context.getResources().getColor(2131034766);
            cardBgColor = this.context.getResources().getColor(2131034757);
        } else {
            textColor = this.context.getResources().getColor(2131034742);
            cardBgColor = this.context.getResources().getColor(2131034758);
        }
        if (!games.getBgImage().trim().equals("")) {
            Picasso.get().load("https://gaou.biogenesis.fr/" + games.getBgImage()).into(holder.gameBg);
        } else {
            holder.gameBg.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)2131165413));
        }
        holder.gameCard.setCardBackgroundColor(cardBgColor);
        holder.gameName.setText((CharSequence)games.getName());
        holder.gameName.setTextColor(textColor);
        holder.gameCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GamesAdapter.this.mInterstitialAd != null) {
                    GamesAdapter.this.mInterstitialAd.show(GamesAdapter.this.activity);
                    GamesAdapter.this.mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                        public void onAdDismissedFullScreenContent() {
                            super.onAdDismissedFullScreenContent();
                            GamesAdapter.this.startGame(games);
                        }
                    });
                } else {
                    GamesAdapter.this.startGame(games);
                }
            }
        });
    }

    public int getItemCount() {
        if (this.gamesList.size() != 0) {
            return this.gamesList.size();
        }
        return 0;
    }

    private void loadInterstitialAd() {
        if (this.adEnabled == 1) {
            AdRequest adRequest = new AdRequest.Builder().build();
            InterstitialAd.load((Context)this.context, (String)this.interstitialAdId, (AdRequest)adRequest, (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d((String)GamesAdapter.TAG, (String)("Failed to load interstitial ad = " + loadAdError));
                    GamesAdapter.this.mInterstitialAd = null;
                }

                public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                    super.onAdLoaded((Object)interstitialAd);
                    GamesAdapter.this.mInterstitialAd = interstitialAd;
                }
            });
        }
    }

    private void startGame(Games games) {
        Intent intent = new Intent(this.context, GameWebViewScreen.class);
        intent.putExtra("gameUrl", games.getGameUrl());
        intent.putExtra("gameName", games.getName());
        intent.putExtra("adEnabled", this.adEnabled);
        intent.putExtra("interstitialAdId", this.interstitialAdId);
        this.context.startActivity(intent);
    }

    public static class GamesViewHolder
    extends RecyclerView.ViewHolder {
        TextView gameName;
        ImageView gameBg;
        MaterialCardView gameCard;

        public GamesViewHolder(@NonNull View itemView) {
            super(itemView);
            this.gameName = (TextView)itemView.findViewById(2131296569);
            this.gameBg = (ImageView)itemView.findViewById(2131296565);
            this.gameCard = (MaterialCardView)itemView.findViewById(2131296567);
        }
    }
}

