/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.ElyStudio.leGaou.activities.QuizHistoryScreen;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.activities.UpdateAvatarActivity;
import com.ElyStudio.leGaou.databinding.ActivityUserProfileScreenBinding;
import com.ElyStudio.leGaou.models.ApiResponse;
import com.ElyStudio.leGaou.models.UserData;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.card.MaterialCardView;
import com.google.firebase.auth.FirebaseAuth;
import com.squareup.picasso.Picasso;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class UserProfileScreen
extends AppCompat {
    ActivityUserProfileScreenBinding binding;
    BottomSheetDialog updateBottomSheet;
    BottomSheetDialog updateNameBottomSheet;
    BottomSheetDialog noInternetBottomSheet;
    BottomSheetDialog errorOccurredBottomSheet;
    public static final String TAG = "USER_PROFILE SCREEN";
    String userName;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityUserProfileScreenBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.viewQuizHistoryCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UserProfileScreen.this.startActivity(new Intent((Context)UserProfileScreen.this, QuizHistoryScreen.class));
            }
        });
        this.binding.updateDetailsCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UserProfileScreen.this.showUpdateBottomSheet();
            }
        });
    }

    protected void onStart() {
        super.onStart();
        this.getUserData();
    }

    private void getUserData() {
        if (CheckInternetConnection.isInternetConnected((Context)this)) {
            Call<UserData> getUserDataCall = ApiController.getInstance().getApi().getUserData(FirebaseAuth.getInstance().getUid());
            getUserDataCall.enqueue((Callback)new Callback<UserData>(){

                public void onResponse(Call<UserData> call, Response<UserData> response) {
                    assert (response.body() != null);
                    if (((UserData)response.body()).getStatusCode() == 0) {
                        UserData user = (UserData)response.body();
                        UserProfileScreen.this.userName = user.getName();
                        UserProfileScreen.this.binding.profileUserName.setText((CharSequence)user.getName());
                        UserProfileScreen.this.binding.profileUserEmail.setText((CharSequence)user.getEmail());
                        UserProfileScreen.this.binding.profileUserCoins.setText((CharSequence)String.valueOf(user.getCoins()));
                        UserProfileScreen.this.binding.profileUserTotalCoins.setText((CharSequence)String.valueOf(user.getTotalCoins()));
                        UserProfileScreen.this.binding.profileUserLevel.setText((CharSequence)user.getUserLevel());
                        if (!user.getUserLevelIcon().trim().isEmpty()) {
                            Picasso.get().load("https://gaou.biogenesis.fr/" + user.getUserLevelIcon()).into(UserProfileScreen.this.binding.profileUserLevelIcon);
                        } else {
                            UserProfileScreen.this.binding.profileUserLevelIcon.setImageDrawable(ContextCompat.getDrawable((Context)UserProfileScreen.this, (int)2131165413));
                        }
                        if (!user.getAvatar().trim().isEmpty()) {
                            Picasso.get().load("https://gaou.biogenesis.fr/" + user.getAvatar()).into(UserProfileScreen.this.binding.userProfileAvatar);
                        } else {
                            UserProfileScreen.this.binding.userProfileAvatar.setImageDrawable(ContextCompat.getDrawable((Context)UserProfileScreen.this, (int)2131165413));
                        }
                    } else {
                        UserProfileScreen.this.showErrorOccurredBottomSheet();
                    }
                }

                public void onFailure(Call<UserData> call, Throwable t) {
                    UserProfileScreen.this.showErrorOccurredBottomSheet();
                    Log.d((String)UserProfileScreen.TAG, (String)("getUserDataCall Failure = " + t.getLocalizedMessage()));
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    public void showUpdateBottomSheet() {
        this.updateBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131493017, (ViewGroup)((ConstraintLayout)this.findViewById(2131297095)), false);
        this.updateBottomSheet.setContentView(view);
        MaterialCardView changeAvatarCard = (MaterialCardView)this.updateBottomSheet.findViewById(2131296442);
        MaterialCardView updateNameCard = (MaterialCardView)this.updateBottomSheet.findViewById(2131297099);
        updateNameCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (UserProfileScreen.this.updateBottomSheet.isShowing()) {
                    UserProfileScreen.this.updateBottomSheet.cancel();
                }
                UserProfileScreen.this.showUpdateNameBottomSheet();
            }
        });
        changeAvatarCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UserProfileScreen.this.startActivity(new Intent((Context)UserProfileScreen.this, UpdateAvatarActivity.class));
            }
        });
        if (!this.isFinishing()) {
            this.updateBottomSheet.show();
        }
    }

    private void showUpdateNameBottomSheet() {
        this.updateNameBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131493018, (ViewGroup)((ConstraintLayout)this.findViewById(2131297097)), false);
        this.updateNameBottomSheet.setContentView(view);
        final EditText updateNameEditText = (EditText)this.updateNameBottomSheet.findViewById(2131297100);
        Button updateNameBtn = (Button)this.updateNameBottomSheet.findViewById(2131297098);
        updateNameEditText.setText((CharSequence)this.userName);
        updateNameBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (updateNameEditText.getText().toString().equals(UserProfileScreen.this.userName)) {
                    if (UserProfileScreen.this.updateNameBottomSheet.isShowing()) {
                        UserProfileScreen.this.updateNameBottomSheet.cancel();
                    }
                } else if (updateNameEditText.getText().toString().trim().isEmpty()) {
                    QuizzeSnackBar.showSnackBar((Context)UserProfileScreen.this, view, UserProfileScreen.this.getResources().getString(2131886430), UserProfileScreen.this.getResources().getColor(2131034225));
                } else {
                    UserProfileScreen.this.updateName(updateNameEditText.getText().toString());
                }
            }
        });
        if (!this.isFinishing()) {
            this.updateNameBottomSheet.show();
        }
    }

    private void updateName(String name) {
        Call<ApiResponse> updateNameCall = ApiController.getInstance().getApi().updateName(FirebaseAuth.getInstance().getUid(), name);
        updateNameCall.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (((ApiResponse)response.body()).getStatusCode() == 0) {
                    if (UserProfileScreen.this.updateNameBottomSheet.isShowing()) {
                        UserProfileScreen.this.updateNameBottomSheet.cancel();
                        QuizzeSnackBar.showSnackBar((Context)UserProfileScreen.this, (View)UserProfileScreen.this.binding.getRoot(), UserProfileScreen.this.getResources().getString(2131886338), UserProfileScreen.this.getResources().getColor(2131034780));
                        UserProfileScreen.this.getUserData();
                    }
                } else {
                    QuizzeSnackBar.showSnackBar((Context)UserProfileScreen.this, (View)UserProfileScreen.this.binding.getRoot(), UserProfileScreen.this.getResources().getString(2131886224), UserProfileScreen.this.getResources().getColor(2131034225));
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable t) {
                QuizzeSnackBar.showSnackBar((Context)UserProfileScreen.this, (View)UserProfileScreen.this.binding.getRoot(), UserProfileScreen.this.getResources().getString(2131886416), UserProfileScreen.this.getResources().getColor(2131034225));
                Log.d((String)UserProfileScreen.TAG, (String)("updateNameCall Failure = " + t.getLocalizedMessage()));
            }
        });
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected((Context)UserProfileScreen.this)) {
                    UserProfileScreen.this.noInternetBottomSheet.cancel();
                    UserProfileScreen.this.getUserData();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)UserProfileScreen.this, view, UserProfileScreen.this.getResources().getString(2131886351), UserProfileScreen.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165481));
        if (!this.isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UserProfileScreen.this.startActivity(new Intent((Context)UserProfileScreen.this, SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UserProfileScreen.this.errorOccurredBottomSheet.cancel();
                UserProfileScreen.this.getUserData();
            }
        });
        if (!this.isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }
}

