/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.ElyStudio.leGaou.activities.MainActivity;
import com.ElyStudio.leGaou.databinding.ActivityQuizResultScreenBinding;
import com.ElyStudio.leGaou.models.ApiResponse;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.firebase.auth.FirebaseAuth;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class QuizResultScreen
extends AppCompat {
    ActivityQuizResultScreenBinding binding;
    int score;
    int totalQuestions;
    int questionAttempted;
    int correctAnswers;
    int wrongAnswers;
    float prizePerQuestion;
    int prize;
    int bonus;
    String quizName;
    String quizIcon;
    int quizColor;
    int quizEntryFee;
    public static final String TAG = "QUIZ_RESULT_SCREEN";
    private RewardedAd mRewardedAd;
    private InterstitialAd mInterstitialAd;
    int adEnabled;
    String nativeAdId;
    String interstitialAdId;
    String rewardedAdId;
    BottomSheetDialog noInternetBottomSheet;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityQuizResultScreenBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.getResultData();
        this.setUpScoreCard();
        this.prize = (int)(this.prizePerQuestion * (float)this.correctAnswers);
        this.bonus = (int)((double)this.prize * 0.25);
        String quizTitle = this.quizName + ' ' + this.getResources().getString(2131886400);
        String userPrize = this.getResources().getString(2131886453) + ' ' + this.prize;
        String bonusCoins = this.getResources().getString(2131886136) + " +" + this.bonus;
        this.binding.resultTitle.setText((CharSequence)quizTitle);
        this.binding.userPrize.setText((CharSequence)userPrize);
        this.binding.bonusCoin.setText((CharSequence)bonusCoins);
        this.binding.bonusCoinButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizResultScreen.this.binding.bonusCoinButton.setVisibility(8);
                QuizResultScreen.this.binding.adProgressBar.setVisibility(0);
                QuizResultScreen.this.loadRewardedAd();
            }
        });
        this.binding.claimPrizeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizResultScreen.this.getQuizPrize();
            }
        });
    }

    protected void onStart() {
        super.onStart();
        this.getResultData();
        this.loadNativeAd(this.binding.adPlaceHolderLayout);
        this.loadInterstitialAd();
    }

    public void getResultData() {
        this.adEnabled = this.getIntent().getIntExtra("adEnabled", 0);
        this.nativeAdId = this.getIntent().getStringExtra("nativeAdId");
        this.interstitialAdId = this.getIntent().getStringExtra("interstitialAdId");
        this.rewardedAdId = this.getIntent().getStringExtra("rewardedAdId");
        this.quizName = this.getIntent().getStringExtra("quizName");
        this.quizIcon = this.getIntent().getStringExtra("quizIcon");
        this.quizColor = this.getIntent().getIntExtra("quizColorCode", 0);
        this.quizEntryFee = this.getIntent().getIntExtra("quizEntryFee", 0);
        this.score = this.getIntent().getIntExtra("quizUserScore", 0);
        this.totalQuestions = this.getIntent().getIntExtra("quizQuestionLimit", 0);
        this.questionAttempted = this.getIntent().getIntExtra("quizQuestionAttempted", 0);
        this.correctAnswers = this.getIntent().getIntExtra("quizCorrectAnswers", 0);
        this.wrongAnswers = this.getIntent().getIntExtra("quizWrongAnswers", 0);
        this.prizePerQuestion = this.getIntent().getFloatExtra("quizPrizePerQuestion", 0.0f);
    }

    public void setUpScoreCard() {
        this.binding.questionAttemptedProgressBar.setMax(this.totalQuestions);
        this.binding.correctAnswerProgressBar.setMax(this.questionAttempted);
        this.binding.wrongAnswerProgressBar.setMax(this.questionAttempted);
        this.binding.questionAttempted.setText((CharSequence)String.valueOf(this.questionAttempted));
        this.binding.correctAnswers.setText((CharSequence)String.valueOf(this.correctAnswers));
        this.binding.wrongAnswers.setText((CharSequence)String.valueOf(this.wrongAnswers));
        this.binding.userScore.setText((CharSequence)String.valueOf(this.score));
        if (Build.VERSION.SDK_INT >= 24) {
            this.binding.questionAttemptedProgressBar.setProgress(this.questionAttempted, true);
            this.binding.correctAnswerProgressBar.setProgress(this.correctAnswers, true);
            this.binding.wrongAnswerProgressBar.setProgress(this.wrongAnswers, true);
        } else {
            this.binding.questionAttemptedProgressBar.setProgress(this.questionAttempted);
            this.binding.correctAnswerProgressBar.setProgress(this.correctAnswers);
            this.binding.wrongAnswerProgressBar.setProgress(this.wrongAnswers);
        }
    }

    public void loadRewardedAd() {
        if (this.rewardedAdId == null) {
            this.adEnabled = this.getIntent().getIntExtra("adEnabled", 0);
            this.rewardedAdId = this.getIntent().getStringExtra("rewardedAdId");
        }
        if (this.adEnabled == 1) {
            AdRequest adRequest = new AdRequest.Builder().build();
            RewardedAd.load((Context)this, (String)this.rewardedAdId, (AdRequest)adRequest, (RewardedAdLoadCallback)new RewardedAdLoadCallback(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    QuizResultScreen.this.mRewardedAd = null;
                    QuizResultScreen.this.binding.bonusCoinButton.setVisibility(0);
                    QuizResultScreen.this.binding.adProgressBar.setVisibility(8);
                    QuizzeSnackBar.showSnackBar((Context)QuizResultScreen.this, (View)QuizResultScreen.this.binding.getRoot(), QuizResultScreen.this.getResources().getString(2131886348), QuizResultScreen.this.getResources().getColor(2131034225));
                }

                public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
                    super.onAdLoaded((Object)rewardedAd);
                    QuizResultScreen.this.mRewardedAd = rewardedAd;
                    QuizResultScreen.this.mRewardedAd.show((Activity)QuizResultScreen.this, new OnUserEarnedRewardListener(){

                        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                            QuizResultScreen.this.prize += QuizResultScreen.this.bonus;
                            String userPrizeWon = QuizResultScreen.this.getResources().getString(2131886453) + ' ' + QuizResultScreen.this.prize;
                            QuizResultScreen.this.binding.userPrize.setText((CharSequence)userPrizeWon);
                            QuizResultScreen.this.binding.bonusCoinButton.setVisibility(8);
                            QuizResultScreen.this.binding.adProgressBar.setVisibility(8);
                        }
                    });
                }
            });
        } else {
            this.binding.bonusCoinButton.setVisibility(0);
            this.binding.adProgressBar.setVisibility(8);
            QuizzeSnackBar.showSnackBar((Context)this, (View)this.binding.getRoot(), this.getResources().getString(2131886348), this.getResources().getColor(2131034225));
        }
    }

    public void loadNativeAd(final FrameLayout frameLayout) {
        if (this.nativeAdId == null) {
            this.adEnabled = this.getIntent().getIntExtra("adEnabled", 0);
            this.nativeAdId = this.getIntent().getStringExtra("nativeAdId");
        }
        if (this.adEnabled == 1) {
            AdLoader.Builder builder = new AdLoader.Builder((Context)this, this.nativeAdId);
            builder.forNativeAd(new NativeAd.OnNativeAdLoadedListener(){

                public void onNativeAdLoaded(@NonNull NativeAd nativeAd) {
                    NativeAdView nativeAdView = (NativeAdView)QuizResultScreen.this.getLayoutInflater().inflate(2131492964, null);
                    QuizResultScreen.this.populateNativeAd(nativeAd, nativeAdView);
                    frameLayout.removeAllViews();
                    frameLayout.addView((View)nativeAdView);
                }
            });
            AdLoader adLoader = builder.withAdListener(new AdListener(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d((String)QuizResultScreen.TAG, (String)("Failed to load interstitial ad = " + loadAdError));
                }

                public void onAdLoaded() {
                    super.onAdLoaded();
                }
            }).build();
            adLoader.loadAd(new AdRequest.Builder().build());
        }
    }

    public void populateNativeAd(NativeAd nativeAd, NativeAdView nativeAdView) {
        nativeAdView.setHeadlineView(nativeAdView.findViewById(2131296343));
        nativeAdView.setIconView(nativeAdView.findViewById(2131296346));
        nativeAdView.setBodyView(nativeAdView.findViewById(2131296336));
        nativeAdView.setCallToActionView(nativeAdView.findViewById(2131296426));
        nativeAdView.setAdvertiserView(nativeAdView.findViewById(2131296333));
        ((TextView)nativeAdView.getHeadlineView()).setText((CharSequence)nativeAd.getHeadline());
        if (nativeAd.getIcon() == null) {
            nativeAdView.getIconView().setVisibility(4);
        } else {
            nativeAdView.getIconView().setVisibility(0);
            ((ImageView)nativeAdView.getIconView()).setImageDrawable(nativeAd.getIcon().getDrawable());
        }
        if (nativeAd.getBody() == null) {
            nativeAdView.getBodyView().setVisibility(4);
        } else {
            nativeAdView.getBodyView().setVisibility(0);
            ((TextView)nativeAdView.getBodyView()).setText((CharSequence)nativeAd.getBody());
        }
        if (nativeAd.getCallToAction() == null) {
            nativeAdView.getCallToActionView().setVisibility(4);
        } else {
            nativeAdView.getCallToActionView().setVisibility(0);
            ((Button)nativeAdView.getCallToActionView()).setText((CharSequence)nativeAd.getCallToAction());
        }
        if (nativeAd.getAdvertiser() == null) {
            nativeAdView.getAdvertiserView().setVisibility(4);
        } else {
            nativeAdView.getAdvertiserView().setVisibility(0);
            ((TextView)nativeAdView.getAdvertiserView()).setText((CharSequence)nativeAd.getAdvertiser());
        }
        nativeAdView.setNativeAd(nativeAd);
    }

    public void loadInterstitialAd() {
        if (this.adEnabled == 1) {
            AdRequest adRequest = new AdRequest.Builder().build();
            InterstitialAd.load((Context)this, (String)this.interstitialAdId, (AdRequest)adRequest, (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d((String)QuizResultScreen.TAG, (String)("Failed to load interstitial ad  = " + loadAdError));
                }

                public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                    super.onAdLoaded((Object)interstitialAd);
                    QuizResultScreen.this.mInterstitialAd = interstitialAd;
                }
            });
        }
    }

    public void showInterstitialAd() {
        this.binding.claimPrizeButton.setVisibility(8);
        this.binding.quizResultProgressBar.setVisibility(0);
        if (this.interstitialAdId == null) {
            this.adEnabled = this.getIntent().getIntExtra("adEnabled", 0);
            this.interstitialAdId = this.getIntent().getStringExtra("interstitialAdId");
        }
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.show((Activity)this);
            this.mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                public void onAdDismissedFullScreenContent() {
                    super.onAdDismissedFullScreenContent();
                    QuizResultScreen.this.startActivity(new Intent((Context)QuizResultScreen.this, MainActivity.class));
                    QuizResultScreen.this.finish();
                }
            });
        } else {
            this.startActivity(new Intent((Context)this, MainActivity.class));
            this.finish();
        }
    }

    private void getQuizPrize() {
        String quizHistoryActivity = this.quizName + ' ' + this.getResources().getString(2131886384);
        if (this.quizIcon == null) {
            this.quizIcon = "";
        }
        if (CheckInternetConnection.isInternetConnected((Context)this)) {
            Call<ApiResponse> getQuizPrizeCall = ApiController.getInstance().getApi().getQuizPrize(FirebaseAuth.getInstance().getUid(), this.quizName, this.quizIcon, this.quizColor, this.totalQuestions, this.questionAttempted, this.correctAnswers, this.wrongAnswers, this.quizEntryFee, this.prize, quizHistoryActivity);
            getQuizPrizeCall.enqueue((Callback)new Callback<ApiResponse>(){

                public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                    if (((ApiResponse)response.body()).getStatusCode() == 0) {
                        QuizResultScreen.this.showInterstitialAd();
                    } else {
                        Log.d((String)QuizResultScreen.TAG, (String)("getQuizPrizeCall Response = " + ((ApiResponse)response.body()).getMessage()));
                        QuizzeSnackBar.showSnackBar((Context)QuizResultScreen.this, (View)QuizResultScreen.this.binding.getRoot(), QuizResultScreen.this.getResources().getString(2131886224), QuizResultScreen.this.getResources().getColor(2131034225));
                        QuizResultScreen.this.startActivity(new Intent((Context)QuizResultScreen.this, MainActivity.class));
                        QuizResultScreen.this.finish();
                    }
                }

                public void onFailure(Call<ApiResponse> call, Throwable t) {
                    Log.d((String)QuizResultScreen.TAG, (String)("getQuizPrizeCall Failure = " + t.getLocalizedMessage()));
                    QuizzeSnackBar.showSnackBar((Context)QuizResultScreen.this, (View)QuizResultScreen.this.binding.getRoot(), QuizResultScreen.this.getResources().getString(2131886416), QuizResultScreen.this.getResources().getColor(2131034225));
                    QuizResultScreen.this.startActivity(new Intent((Context)QuizResultScreen.this, MainActivity.class));
                    QuizResultScreen.this.finish();
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected((Context)QuizResultScreen.this)) {
                    QuizResultScreen.this.noInternetBottomSheet.cancel();
                    QuizResultScreen.this.getQuizPrize();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)QuizResultScreen.this, view, QuizResultScreen.this.getResources().getString(2131886351), QuizResultScreen.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165481));
        if (!this.isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }
}

