/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.adapter.QuizHistoryAdapter;
import com.ElyStudio.leGaou.databinding.ActivityQuizHistoryScreenBinding;
import com.ElyStudio.leGaou.models.GetQuizHistory;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.firebase.auth.FirebaseAuth;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class QuizHistoryScreen
extends AppCompat {
    ActivityQuizHistoryScreenBinding binding;
    BottomSheetDialog noInternetBottomSheet;
    BottomSheetDialog errorOccurredBottomSheet;
    public static final String TAG = "QUIZ_HISTORY_SCREEN";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityQuizHistoryScreenBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
    }

    protected void onStart() {
        super.onStart();
        this.getQuizHistory();
    }

    private void getQuizHistory() {
        if (CheckInternetConnection.isInternetConnected((Context)this)) {
            Call<GetQuizHistory> getQuizHistoryCall = ApiController.getInstance().getApi().getQuizHistory(FirebaseAuth.getInstance().getUid());
            getQuizHistoryCall.enqueue((Callback)new Callback<GetQuizHistory>(){

                public void onResponse(Call<GetQuizHistory> call, Response<GetQuizHistory> response) {
                    if (((GetQuizHistory)response.body()).getStatusCode() == 0) {
                        if (((GetQuizHistory)response.body()).getQuizHistoryList() != null) {
                            QuizHistoryScreen.this.binding.quizHistoryRecyclerview.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)QuizHistoryScreen.this, 1, false));
                            QuizHistoryScreen.this.binding.quizHistoryRecyclerview.setAdapter((RecyclerView.Adapter)new QuizHistoryAdapter(((GetQuizHistory)response.body()).getQuizHistoryList(), (Context)QuizHistoryScreen.this));
                        }
                    } else {
                        QuizHistoryScreen.this.showErrorOccurredBottomSheet();
                    }
                }

                public void onFailure(Call<GetQuizHistory> call, Throwable t) {
                    QuizHistoryScreen.this.showErrorOccurredBottomSheet();
                    Log.d((String)QuizHistoryScreen.TAG, (String)("getQuizHistoryCall Failure = " + t.getLocalizedMessage()));
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected((Context)QuizHistoryScreen.this)) {
                    QuizHistoryScreen.this.noInternetBottomSheet.cancel();
                    QuizHistoryScreen.this.getQuizHistory();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)QuizHistoryScreen.this, view, QuizHistoryScreen.this.getResources().getString(2131886351), QuizHistoryScreen.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165481));
        if (!this.isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizHistoryScreen.this.startActivity(new Intent((Context)QuizHistoryScreen.this, SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizHistoryScreen.this.errorOccurredBottomSheet.cancel();
                QuizHistoryScreen.this.getQuizHistory();
            }
        });
        if (!this.isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }
}

