/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.ElyStudio.leGaou.activities.AvatarSelectionScreen;
import com.ElyStudio.leGaou.activities.MainActivity;
import com.ElyStudio.leGaou.activities.PrivacyPolicyScreen;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.adapter.OnboardingAdapter;
import com.ElyStudio.leGaou.databinding.ActivityOnboardingScreenBinding;
import com.ElyStudio.leGaou.models.ApiResponse;
import com.ElyStudio.leGaou.models.OnboardingItem;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.airbnb.lottie.LottieAnimationView;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.card.MaterialCardView;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.GoogleAuthProvider;
import java.util.ArrayList;
import java.util.Objects;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class OnboardingScreen
extends AppCompat {
    ActivityOnboardingScreenBinding binding;
    OnboardingAdapter onboardingAdapter;
    private LinearLayout onboardingIndicatorLayout;
    BottomSheetDialog loginBottomSheet;
    private final String TAG = "ONBOARDING_SCREEN";
    private FirebaseAuth firebaseAuth;
    private GoogleSignInClient googleSignInClient;
    private final int REQ_SIGN_IN = 0;
    LottieAnimationView loader;
    MaterialCardView googleSignInButton;
    BottomSheetDialog noInternetBottomSheet;
    BottomSheetDialog errorOccurredBottomSheet;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityOnboardingScreenBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        FirebaseApp.initializeApp((Context)this);
        this.firebaseAuth = FirebaseAuth.getInstance();
        this.onboardingIndicatorLayout = this.binding.onboardingIndicator;
        this.setOnboardingData();
        this.binding.onboardingViewPager.setAdapter((RecyclerView.Adapter)this.onboardingAdapter);
        this.setupOnboardingIndicators();
        this.setCurrentOnboardingIndicator(0);
        this.binding.onboardingViewPager.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback(){

            public void onPageSelected(int position) {
                super.onPageSelected(position);
                OnboardingScreen.this.setCurrentOnboardingIndicator(position);
            }
        });
        this.binding.nextBtn.setOnClickListener(v -> {
            if (this.binding.onboardingViewPager.getCurrentItem() + 1 < this.onboardingAdapter.getItemCount()) {
                this.binding.onboardingViewPager.setCurrentItem(this.binding.onboardingViewPager.getCurrentItem() + 1);
            } else if (CheckInternetConnection.isInternetConnected((Context)this)) {
                this.showLoginBottomSheet();
            } else {
                this.showNoInternetBottomSheet();
            }
        });
        this.binding.skipBtn.setOnClickListener(v -> this.showLoginBottomSheet());
        GoogleSignInOptions googleSignInOptions = new GoogleSignInOptions.Builder().requestIdToken("1001117457395-ku0cvnjjph0qp2gv4cu34qshv5us94p1.apps.googleusercontent.com").requestEmail().build();
        this.googleSignInClient = GoogleSignIn.getClient((Activity)this, (GoogleSignInOptions)googleSignInOptions);
    }

    private void signIn() {
        this.googleSignInClient.signOut();
        Intent signInIntent = this.googleSignInClient.getSignInIntent();
        Toast.makeText((Context)this, (CharSequence)"avant!", (int)0).show();
        this.startActivityForResult(signInIntent, 0);
        Toast.makeText((Context)this, (CharSequence)"apr\u00e8s!", (int)0).show();
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 0) {
            Task task = GoogleSignIn.getSignedInAccountFromIntent((Intent)data);
            this.handleSignInResult((Task<GoogleSignInAccount>)task);
        }
    }

    private void handleSignInResult(Task<GoogleSignInAccount> task) {
        try {
            GoogleSignInAccount account = (GoogleSignInAccount)task.getResult(ApiException.class);
            this.firebaseAuthWithGoogle(account);
            Log.d((String)"ONBOARDING_SCREEN", (String)("firebaseAuthWithGoogle:" + account.getId()));
        }
        catch (ApiException e) {
            this.loader.setVisibility(8);
            this.googleSignInButton.setVisibility(0);
            Log.w((String)"ONBOARDING_SCREEN", (String)"Google sign in failed", (Throwable)e);
        }
    }

    private void firebaseAuthWithGoogle(GoogleSignInAccount account) {
        AuthCredential credential = GoogleAuthProvider.getCredential((String)account.getIdToken(), null);
        this.firebaseAuth.signInWithCredential(credential).addOnSuccessListener(authResult -> {
            Log.d((String)"ONBOARDING_SCREEN", (String)"Firebase auth successful");
            this.proceedSignIn(this.firebaseAuth.getUid(), account.getDisplayName(), account.getEmail(), Objects.requireNonNull(this.firebaseAuth.getUid()).substring(0, 4));
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                Log.d((String)"ONBOARDING_SCREEN", (String)e.getLocalizedMessage());
                OnboardingScreen.this.loader.setVisibility(8);
                OnboardingScreen.this.googleSignInButton.setVisibility(0);
            }
        });
    }

    private void proceedSignIn(String uId, String name, String email, String inviteCode) {
        if (name == null || name.equals("")) {
            name = this.getResources().getString(2131886214) + Objects.requireNonNull(this.firebaseAuth.getUid()).substring(0, 4);
        }
        Call<ApiResponse> proceedSignInCall = ApiController.getInstance().getApi().registerUser(uId, name, email, inviteCode);
        proceedSignInCall.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                assert (response.body() != null);
                if (((ApiResponse)response.body()).getStatusCode() == 0) {
                    OnboardingScreen.this.loginBottomSheet.cancel();
                    OnboardingScreen.this.startActivity(new Intent((Context)OnboardingScreen.this, AvatarSelectionScreen.class));
                    OnboardingScreen.this.finish();
                } else if (((ApiResponse)response.body()).getStatusCode() == 1) {
                    OnboardingScreen.this.loginBottomSheet.cancel();
                    OnboardingScreen.this.startActivity(new Intent((Context)OnboardingScreen.this, MainActivity.class));
                    OnboardingScreen.this.finish();
                } else {
                    OnboardingScreen.this.loginBottomSheet.cancel();
                    OnboardingScreen.this.showErrorOccurredBottomSheet();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable t) {
                OnboardingScreen.this.loginBottomSheet.cancel();
                OnboardingScreen.this.showErrorOccurredBottomSheet();
                Log.d((String)"ONBOARDING_SCREEN", (String)("proceedSignInCall Api Failure = " + t.getLocalizedMessage()));
            }
        });
    }

    void setOnboardingData() {
        ArrayList<OnboardingItem> onboardingItemList = new ArrayList<OnboardingItem>();
        OnboardingItem firstSlide = new OnboardingItem();
        firstSlide.setImage(2131165496);
        firstSlide.setTitle(this.getString(2131886367));
        firstSlide.setDescription(this.getString(2131886366));
        OnboardingItem secondSlide = new OnboardingItem();
        secondSlide.setImage(2131165499);
        secondSlide.setTitle(this.getString(2131886371));
        secondSlide.setDescription(this.getString(2131886370));
        OnboardingItem thirdSlide = new OnboardingItem();
        thirdSlide.setImage(2131165498);
        thirdSlide.setTitle(this.getString(2131886369));
        thirdSlide.setDescription(this.getString(2131886368));
        onboardingItemList.add(firstSlide);
        onboardingItemList.add(secondSlide);
        onboardingItemList.add(thirdSlide);
        this.onboardingAdapter = new OnboardingAdapter(onboardingItemList);
    }

    private void setupOnboardingIndicators() {
        ImageView[] indicators = new ImageView[this.onboardingAdapter.getItemCount()];
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.setMargins(8, 0, 8, 0);
        for (int i = 0; i < indicators.length; ++i) {
            indicators[i] = new ImageView(this.getApplicationContext());
            indicators[i].setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165495));
            indicators[i].setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.onboardingIndicatorLayout.addView((View)indicators[i]);
        }
    }

    private void setCurrentOnboardingIndicator(int index) {
        int childCount = this.onboardingIndicatorLayout.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ImageView imageView = (ImageView)this.onboardingIndicatorLayout.getChildAt(i);
            if (i == index) {
                imageView.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165494));
                continue;
            }
            imageView.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165495));
        }
        if (index == this.onboardingAdapter.getItemCount() - 1) {
            this.binding.nextBtn.setText((CharSequence)this.getString(2131886207));
        } else {
            this.binding.nextBtn.setText((CharSequence)this.getString(2131886346));
        }
    }

    void showLoginBottomSheet() {
        this.loginBottomSheet = new BottomSheetDialog((Context)this, 2131951887);
        View view = LayoutInflater.from((Context)this).inflate(2131492944, (ViewGroup)this.findViewById(2131296690));
        this.loginBottomSheet.setContentView(view);
        this.googleSignInButton = (MaterialCardView)view.findViewById(2131296582);
        this.loader = (LottieAnimationView)view.findViewById(2131296685);
        TextView loginGreetings = (TextView)this.loginBottomSheet.findViewById(2131296688);
        TextView privacyPolicyText = (TextView)this.loginBottomSheet.findViewById(2131296845);
        privacyPolicyText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OnboardingScreen.this.startActivity(new Intent((Context)OnboardingScreen.this, PrivacyPolicyScreen.class));
            }
        });
        String greetings = String.format(this.getResources().getString(2131886236), this.getResources().getString(2131886113));
        loginGreetings.setText((CharSequence)greetings);
        this.googleSignInButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OnboardingScreen.this.loader.setVisibility(0);
                OnboardingScreen.this.googleSignInButton.setVisibility(8);
                OnboardingScreen.this.signIn();
            }
        });
        if (!this.isFinishing()) {
            this.loginBottomSheet.show();
        }
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected((Context)OnboardingScreen.this)) {
                    OnboardingScreen.this.noInternetBottomSheet.cancel();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)OnboardingScreen.this, view, OnboardingScreen.this.getResources().getString(2131886351), OnboardingScreen.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165481));
        if (!this.isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OnboardingScreen.this.startActivity(new Intent((Context)OnboardingScreen.this, SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OnboardingScreen.this.errorOccurredBottomSheet.cancel();
            }
        });
        if (!this.isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }
}

