/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.ElyStudio.leGaou.activities.MainActivity;
import com.ElyStudio.leGaou.databinding.ActivityLoseBinding;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;

public class LoseActivity
extends AppCompat {
    ActivityLoseBinding binding;
    private InterstitialAd mInterstitialAd;
    public static final String TAG = "LOSE_ACTIVITY";
    int adEnabled;
    String nativeAdId;
    String interstitialAdId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityLoseBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.goToHomeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LoseActivity.this.showInterstitialAd();
            }
        });
    }

    protected void onStart() {
        super.onStart();
        this.getAdData();
        this.loadNativeAd(this.binding.adPlaceHolder);
        this.loadInterstitialAd();
    }

    private void getAdData() {
        this.adEnabled = this.getIntent().getIntExtra("adEnabled", 0);
        this.nativeAdId = this.getIntent().getStringExtra("nativeAdId");
        this.interstitialAdId = this.getIntent().getStringExtra("interstitialAdId");
    }

    private void loadInterstitialAd() {
        if (this.interstitialAdId == null) {
            this.interstitialAdId = this.getIntent().getStringExtra("interstitialAdId");
            this.getAdData();
        }
        if (this.adEnabled == 1) {
            AdRequest adRequest = new AdRequest.Builder().build();
            InterstitialAd.load((Context)this, (String)this.interstitialAdId, (AdRequest)adRequest, (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d((String)LoseActivity.TAG, (String)("Failed to load interstitial ad  = " + loadAdError));
                    LoseActivity.this.mInterstitialAd = null;
                }

                public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                    super.onAdLoaded((Object)interstitialAd);
                    LoseActivity.this.mInterstitialAd = interstitialAd;
                }
            });
        }
    }

    public void showInterstitialAd() {
        this.binding.progressBar.setVisibility(0);
        this.binding.goToHomeBtn.setVisibility(8);
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.show((Activity)this);
            this.mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                public void onAdDismissedFullScreenContent() {
                    super.onAdDismissedFullScreenContent();
                    LoseActivity.this.mInterstitialAd = null;
                    LoseActivity.this.startActivity(new Intent((Context)LoseActivity.this, MainActivity.class));
                    LoseActivity.this.finish();
                }
            });
        } else {
            this.startActivity(new Intent((Context)this, MainActivity.class));
            this.finish();
        }
    }

    public void loadNativeAd(final FrameLayout adPlaceHolder) {
        if (this.nativeAdId == null) {
            this.getAdData();
        }
        if (this.adEnabled == 1) {
            AdLoader.Builder builder = new AdLoader.Builder((Context)this, this.nativeAdId);
            builder.forNativeAd(new NativeAd.OnNativeAdLoadedListener(){

                public void onNativeAdLoaded(@NonNull NativeAd nativeAd) {
                    NativeAdView nativeAdView = (NativeAdView)LoseActivity.this.getLayoutInflater().inflate(2131492964, null);
                    LoseActivity.this.populateNativeAd(nativeAdView, nativeAd);
                    adPlaceHolder.removeAllViews();
                    adPlaceHolder.addView((View)nativeAdView);
                }
            });
            AdLoader adLoader = builder.withAdListener(new AdListener(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d((String)LoseActivity.TAG, (String)("Failed to load native ad = " + loadAdError));
                }
            }).build();
            adLoader.loadAd(new AdRequest.Builder().build());
        }
    }

    public void populateNativeAd(NativeAdView nativeAdView, NativeAd nativeAd) {
        nativeAdView.setHeadlineView(nativeAdView.findViewById(2131296343));
        nativeAdView.setBodyView(nativeAdView.findViewById(2131296336));
        nativeAdView.setIconView(nativeAdView.findViewById(2131296346));
        nativeAdView.setAdvertiserView(nativeAdView.findViewById(2131296333));
        nativeAdView.setCallToActionView(nativeAdView.findViewById(2131296426));
        ((TextView)nativeAdView.getHeadlineView()).setText((CharSequence)nativeAd.getHeadline());
        if (nativeAd.getIcon() == null) {
            nativeAdView.getIconView().setVisibility(4);
        } else {
            nativeAdView.getIconView().setVisibility(0);
            ((ImageView)nativeAdView.getIconView()).setImageDrawable(nativeAd.getIcon().getDrawable());
        }
        if (nativeAd.getBody() == null) {
            nativeAdView.getBodyView().setVisibility(4);
        } else {
            nativeAdView.getBodyView().setVisibility(0);
            ((TextView)nativeAdView.getBodyView()).setText((CharSequence)nativeAd.getBody());
        }
        if (nativeAd.getAdvertiser() == null) {
            nativeAdView.getAdvertiserView().setVisibility(4);
        } else {
            nativeAdView.getAdvertiserView().setVisibility(0);
            ((TextView)nativeAdView.getAdvertiserView()).setText((CharSequence)nativeAd.getAdvertiser());
        }
        if (nativeAd.getCallToAction() == null) {
            nativeAdView.getCallToActionView().setVisibility(4);
        } else {
            nativeAdView.getCallToActionView().setVisibility(0);
            ((Button)nativeAdView.getCallToActionView()).setText((CharSequence)nativeAd.getCallToAction());
        }
        nativeAdView.setNativeAd(nativeAd);
    }
}

