/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.MainActivity;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.adapter.AvatarAdapter;
import com.ElyStudio.leGaou.databinding.ActivityAvatarSelectionScreenBinding;
import com.ElyStudio.leGaou.models.ApiResponse;
import com.ElyStudio.leGaou.models.Avatars;
import com.ElyStudio.leGaou.models.QuizzeAvatars;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.OnItemClick;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.firebase.auth.FirebaseAuth;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AvatarSelectionScreen
extends AppCompat
implements OnItemClick {
    ActivityAvatarSelectionScreenBinding binding;
    public static final String TAG = "AVATAR_SELECTION_SCREEN";
    RecyclerView avatarRecyclerView;
    String avatarImage;
    BottomSheetDialog nameInputBottomSheet;
    BottomSheetDialog errorOccurredBottomSheet;
    BottomSheetDialog noInternetBottomSheet;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityAvatarSelectionScreenBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.nextBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AvatarSelectionScreen.this.avatarImage != null && !AvatarSelectionScreen.this.avatarImage.equals("")) {
                    AvatarSelectionScreen.this.showNameInputBottomSheet();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)AvatarSelectionScreen.this, (View)AvatarSelectionScreen.this.binding.getRoot(), AvatarSelectionScreen.this.getResources().getString(2131886411), AvatarSelectionScreen.this.getResources().getColor(2131034796));
                }
            }
        });
    }

    protected void onStart() {
        super.onStart();
        this.getAvatars();
    }

    private void getAvatars() {
        if (CheckInternetConnection.isInternetConnected((Context)this)) {
            Call<QuizzeAvatars> getAvatarsCall = ApiController.getInstance().getApi().getAvatars();
            getAvatarsCall.enqueue((Callback)new Callback<QuizzeAvatars>(){

                public void onResponse(Call<QuizzeAvatars> call, Response<QuizzeAvatars> response) {
                    assert (response.body() != null);
                    if (((QuizzeAvatars)response.body()).getstatusCode() == 0) {
                        if (((QuizzeAvatars)response.body()).avatarsList != null) {
                            AvatarSelectionScreen.this.setAvatarRecyclerView(((QuizzeAvatars)response.body()).avatarsList);
                        }
                    } else if (((QuizzeAvatars)response.body()).getstatusCode() == 1) {
                        QuizzeSnackBar.showSnackBar((Context)AvatarSelectionScreen.this, (View)AvatarSelectionScreen.this.binding.getRoot(), AvatarSelectionScreen.this.getResources().getString(2131886349), AvatarSelectionScreen.this.getResources().getColor(2131034225));
                    } else {
                        AvatarSelectionScreen.this.showErrorOccurredBottomSheet();
                    }
                }

                public void onFailure(Call<QuizzeAvatars> call, Throwable t) {
                    AvatarSelectionScreen.this.showErrorOccurredBottomSheet();
                    Log.d((String)AvatarSelectionScreen.TAG, (String)("getAvatarCall Failure =" + t.getLocalizedMessage()));
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    void setAvatarRecyclerView(List<Avatars> avatarsList) {
        this.avatarRecyclerView = this.binding.avatarsRecyclerview;
        GridLayoutManager layoutManager = new GridLayoutManager((Context)this, 2, 1, false);
        AvatarAdapter adapter = new AvatarAdapter(avatarsList, this);
        this.avatarRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.avatarRecyclerView.setAdapter((RecyclerView.Adapter)adapter);
    }

    @Override
    public void onClick(String value) {
        this.avatarImage = value;
    }

    private void showNameInputBottomSheet() {
        this.nameInputBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492995, (ViewGroup)this.findViewById(2131296766));
        this.nameInputBottomSheet.setContentView(view);
        final EditText nameInput = (EditText)view.findViewById(2131297114);
        Button completeButton = (Button)view.findViewById(2131296461);
        completeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String name = nameInput.getText().toString();
                if (name.equals("")) {
                    QuizzeSnackBar.showSnackBar((Context)AvatarSelectionScreen.this, view, AvatarSelectionScreen.this.getResources().getString(2131886183), AvatarSelectionScreen.this.getResources().getColor(2131034796));
                } else {
                    AvatarSelectionScreen.this.updateSignIn(name, AvatarSelectionScreen.this.avatarImage);
                }
            }
        });
        this.nameInputBottomSheet.show();
    }

    void updateSignIn(String name, String avatar) {
        Call<ApiResponse> updateSignInCall = ApiController.getInstance().getApi().updateSignIn(FirebaseAuth.getInstance().getUid(), name, avatar);
        updateSignInCall.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (((ApiResponse)response.body()).getStatusCode() == 0) {
                    AvatarSelectionScreen.this.nameInputBottomSheet.cancel();
                    AvatarSelectionScreen.this.startActivity(new Intent((Context)AvatarSelectionScreen.this, MainActivity.class));
                    AvatarSelectionScreen.this.finish();
                } else {
                    AvatarSelectionScreen.this.nameInputBottomSheet.cancel();
                    QuizzeSnackBar.showSnackBar((Context)AvatarSelectionScreen.this, (View)AvatarSelectionScreen.this.binding.getRoot(), AvatarSelectionScreen.this.getResources().getString(2131886224), AvatarSelectionScreen.this.getResources().getColor(2131034225));
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable t) {
                AvatarSelectionScreen.this.nameInputBottomSheet.cancel();
                QuizzeSnackBar.showSnackBar((Context)AvatarSelectionScreen.this, (View)AvatarSelectionScreen.this.binding.getRoot(), AvatarSelectionScreen.this.getResources().getString(2131886415), AvatarSelectionScreen.this.getResources().getColor(2131034225));
                Log.d((String)AvatarSelectionScreen.TAG, (String)("updateSignInCall Failure = " + t.getLocalizedMessage()));
            }
        });
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected((Context)AvatarSelectionScreen.this)) {
                    AvatarSelectionScreen.this.noInternetBottomSheet.cancel();
                    AvatarSelectionScreen.this.getAvatars();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)AvatarSelectionScreen.this, view, AvatarSelectionScreen.this.getResources().getString(2131886351), AvatarSelectionScreen.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165481));
        if (!this.isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AvatarSelectionScreen.this.startActivity(new Intent((Context)AvatarSelectionScreen.this, SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AvatarSelectionScreen.this.errorOccurredBottomSheet.cancel();
                AvatarSelectionScreen.this.getAvatars();
            }
        });
        if (!this.isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }
}

