/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.adapter.QuizAdapter;
import com.ElyStudio.leGaou.databinding.ActivityAllQuizBinding;
import com.ElyStudio.leGaou.models.GetQuiz;
import com.ElyStudio.leGaou.models.Quiz;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.GridViewSpacing;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AllQuizActivity
extends AppCompat {
    ActivityAllQuizBinding binding;
    RecyclerView quizRecyclerView;
    public static final String TAG = "ALL_QUIZ_ACTIVITY";
    int userCoins;
    int watchEarnReward;
    int adEnabled;
    String nativeAdId;
    String interstitialAdId;
    String rewardedAdId;
    BottomSheetDialog noInternetBottomSheet;
    BottomSheetDialog errorOccurredBottomSheet;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityAllQuizBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
    }

    protected void onStart() {
        super.onStart();
        this.getQuiz();
    }

    void getQuiz() {
        int categoryId = this.getIntent().getIntExtra("categoryId", 0);
        this.userCoins = this.getIntent().getIntExtra("userCoins", 0);
        this.watchEarnReward = this.getIntent().getIntExtra("watchEarnReward", 0);
        if (categoryId != 0) {
            String title = this.getIntent().getStringExtra("categoryTitle");
            this.binding.heading.setText((CharSequence)title);
        }
        if (CheckInternetConnection.isInternetConnected((Context)this)) {
            Call<GetQuiz> getQuizCall = ApiController.getInstance().getApi().getQuiz(categoryId);
            getQuizCall.enqueue((Callback)new Callback<GetQuiz>(){

                public void onResponse(Call<GetQuiz> call, Response<GetQuiz> response) {
                    if (((GetQuiz)response.body()).getStatusCode() == 0) {
                        if (((GetQuiz)response.body()).getQuizList() != null) {
                            AllQuizActivity.this.setQuizRecyclerView(((GetQuiz)response.body()).getQuizList());
                        }
                    } else if (((GetQuiz)response.body()).getStatusCode() == 1) {
                        AllQuizActivity.this.binding.quizRecyclerView.setVisibility(8);
                        AllQuizActivity.this.binding.heading.setVisibility(8);
                        AllQuizActivity.this.binding.noQuizHeading.setVisibility(0);
                        AllQuizActivity.this.binding.emptyIllustration.setVisibility(0);
                    }
                }

                public void onFailure(Call<GetQuiz> call, Throwable t) {
                    AllQuizActivity.this.showErrorOccurredBottomSheet();
                    Log.d((String)AllQuizActivity.TAG, (String)("getQuizCall Failure = " + t.getLocalizedMessage()));
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    void setQuizRecyclerView(List<Quiz> quizList) {
        this.adEnabled = this.getIntent().getIntExtra("adEnabled", 0);
        this.nativeAdId = this.getIntent().getStringExtra("nativeAdId");
        this.interstitialAdId = this.getIntent().getStringExtra("interstitialAdId");
        this.rewardedAdId = this.getIntent().getStringExtra("rewardedAdId");
        this.quizRecyclerView = this.binding.quizRecyclerView;
        GridLayoutManager layoutManager = new GridLayoutManager((Context)this, 2, 1, false);
        QuizAdapter adapter = new QuizAdapter((Context)this, quizList, (Activity)this, (View)this.binding.getRoot(), this.userCoins, this.watchEarnReward, this.adEnabled, this.nativeAdId, this.interstitialAdId, this.rewardedAdId);
        this.quizRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new GridViewSpacing(2, 40, false));
        this.quizRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.quizRecyclerView.setAdapter((RecyclerView.Adapter)adapter);
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected((Context)AllQuizActivity.this)) {
                    AllQuizActivity.this.noInternetBottomSheet.cancel();
                    AllQuizActivity.this.getQuiz();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)AllQuizActivity.this, view, AllQuizActivity.this.getResources().getString(2131886351), AllQuizActivity.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165481));
        if (!this.isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AllQuizActivity.this.startActivity(new Intent((Context)AllQuizActivity.this, SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AllQuizActivity.this.errorOccurredBottomSheet.cancel();
                AllQuizActivity.this.getQuiz();
            }
        });
        if (!this.isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }
}

